//=============================================================================
//
// Ug [modeResult.h]
// Author : KENSUKE WATANABE
//
//=============================================================================
#ifndef _MODERESULT_H_
#define _MODERESULT_H_

#include <vector>
#include "mode.h"

//=============================================================================
// NX`
//-----------------------------------------------------------------------------
// O錾
class CScore;
class CScene2D;
class CBgCylinder;
class CEffectPoly;
class CModeResult : public CMode
{
public:
	CModeResult(): m_createEffectFrame(1), m_bR(true), m_bG(false), m_bB(false) {}
	CModeResult(int score) : m_bR(true), m_bG(false), m_bB(false), m_score(score) {}
	~CModeResult() {}

	void Init(void);	// 
	void Uninit(void);	// I
	void Update(void);	// XV
	void Draw(void);	// `
	void Create(void);

	void GradationCol(int val);
	const int &GetGradR() { return m_gradR; }
	const int &GetGradG() { return m_gradG; }
	const int &GetGradB() { return m_gradB; }
	void SetGrad(const int &r, const int &g, const int &b) { m_gradR = r; m_gradG = g; m_gradB = b; }
	void AddGrad(const int &r, const int &g, const int &b) { m_gradR += r; m_gradG += g; m_gradB += b; }

private:
	int m_createEffectFrame;
	int m_gradR, m_gradG, m_gradB;
	bool m_bR, m_bG, m_bB;
	CBgCylinder *m_pBgCylinder;
	int m_score;
	CScene2D *m_resultButton;
	CEffectPoly *m_resultPoly, *m_resultEnd;
	CScene2D *m_pScoreTex;
	CScore *m_pScore;		// XRA
};

#endif
